% Copyright 2016 Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000 with Sandia
% Corporation, the U.S. Government retains certain rights in this software

% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are
% met:
% 
%     (1) Redistributions of source code must retain the above copyright
%     notice, this list of conditions and the following disclaimer. 
% 
%     (2) Redistributions in binary form must reproduce the above copyright
%     notice, this list of conditions and the following disclaimer in
%     the documentation and/or other materials provided with the
%     distribution.  
%     
%     (3)The name of the author may not be used to
%     endorse or promote products derived from this software without
%     specific prior written permission.
% 
% THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
% IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
% WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
% DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
% INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
% (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
% SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
% HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
% STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
% IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
% POSSIBILITY OF SUCH DAMAGE.

function corrVals = corrColumns(referenceData,comparisonData)

%FUNCTION corrVals = corrColumns(referenceData,comparisonData)
%
% PURPOSE:
%	corrColumns is designed to determine the correlation of each column in
%	one input to the corresponding column in the other input. 
%
% DEPENDENCIES:
%	-None-
%
% CLASSES:
%	-None-
%
% INPUTS:
%	referenceData:
%		A 2D data matrix, the reference data. 
%	comparisonData:
%		A 2D data matrix, the comparison data. 
%
% OUTPUTS:
%	corrVals:
%		A vector, where the jth entry corresponds to the correlation
%		between the jth column of the two inputs. 
%
% REFERENCES:
%	-None-
%
% PROGRAMMER COMMENTS:
%	-None-
%
% LIMITATIONS:
%	-None-

% Revision:
%	Sandia Hyper-UBS 1.0.0

%Determine the number of columns and ensure that they are equal. 
refSize = size(referenceData);
compSize = size(comparisonData);
if ~isequal(refSize,compSize)
	error('corrColumns:Mismatch','The two inputs must have the same size!')
end

%Determine the means
meanRef = mean(referenceData,1);
meanComp = mean(comparisonData,1);

%Determine the standard deviations
stdRef = std(referenceData,0,1);
stdComp = std(comparisonData,0,1);

%Determine the correlation coefficient
corrVals = (sum(referenceData.*comparisonData,1)-refSize(1)*meanRef.*meanComp)/(refSize(1)-1)./stdRef./stdComp;



